#!/usr/bin/python
import igraph as ig
import sys
import os

def main():
   
   if len(sys.argv) < 3:
      print "Usage: pajek2gml.py <input .net file> <output .gml file>"
      return

   net = sys.argv[1]
   outnet = sys.argv[2]

   g = ig.Graph.Read_Pajek(net)

   #ebc = g.edge_betweenness()
   #maxEbc = max(ebc)

   #for e, bc in enumerate(ebc):
   #   g.es[e]["weight"] = 1.0 + maxEbc - bc
   g.vs["label"] = g.vs["id"]
   g.es["w"] = g.es["weight"]

   g.write_gml(outnet+".tmp")
 

   #little hack for being Cytoscape compatible... :)
   file1 = open(outnet+".tmp")
   file2 = open(outnet,"w")
   for line in file1.readlines():
      if (line.lstrip().startswith("w ") or line.lstrip().startswith("weight ")) and line.find(".")==-1:
         file2.write(line.rstrip()+".0\r\n")
      else:
         file2.write(line.rstrip()+"\r\n")

   file1.close()
   file2.close()

   os.remove(outnet+".tmp")
   


main()
