#!/usr/bin/python
import igraph as ig
import igraph.clustering
import sys
import random

def get_random_subgraph(g, size):
    subgraph_clu = [0]*g.vcount()
    nodenum = g.vcount()
    sub_size = nodenum
    while sub_size > size:
	found = 0
        while found==0:
	    next = random.randint(0,nodenum-1)
	    while subgraph_clu[next] == 1: 
		next = random.randint(0,nodenum-1)
	    #print "gyaa 1 " + str(next)
	    act_subgr = list(subgraph_clu)
	    act_subgr[next] = 1
	    cl = igraph.clustering.Clustering(act_subgr)
	    if len(g.subgraph(cl[0]).components())==1: 
		found=1
		sub_size-=1
		subgraph_clu[next] = 1
    cl = igraph.clustering.Clustering(subgraph_clu)
    return tuple(cl[0])
    
 

def main():
   
    if len(sys.argv) < 5:
	print "Usage: random_networks.py <.net network file> <output prefix> <subnet size> <number of expected different samples>"
	print "    Generates random connected subgraphs from the original network."
	return

    net = sys.argv[1]
    workdir = sys.argv[2]
    size = int(sys.argv[3])
    num = int(sys.argv[4])

    g = ig.Graph.Read_Pajek(net)

    if size >= g.vcount():
	print "ERROR: random subcomponent size is higher or equal then the graph vertex number"
	return 

    if len(g.components()) > 1:
	print "ERROR: the original network is not strongly connected" 
	#print "ERROR: the original network is not strongly connected" + str(len(g.components())) 
	#for comp
	return 
    

    random.seed() #Set the seed based on the system time

    samples = set()
    i=0
    while len(samples)<num:
	samples.add(get_random_subgraph(g, size))
	if len(samples) > i:
	    print str(i+1) + "/" + str(num)
	    i = len(samples) 	
  
    i = 0
    for sample in samples:
	g.subgraph(sample).write_pajek(workdir + "_" + str(i)+".net")
	i += 1     



main()
